import subprocess

def run_script(script_name):
    try:
        subprocess.run(['python', script_name], check=True)
    except subprocess.CalledProcessError as e:
        print(f"Error occurred while running {script_name}: {e}")

def main():
    print("Please press 'a' if you want to convert a single image")
    print("Please press 'b' if you want to batch convert images")

    choice = input("Your choice: ").strip().lower()

    if choice == 'a':
        run_script('imgmgck-convert.py')
    elif choice == 'b':
        run_script('imgmgckmogrify.py')
    else:
        print("Invalid choice. Please press 'a' or 'b'.")

if __name__ == "__main__":
    main()