import subprocess

def run_script(script_name):
    try:
        subprocess.run(['python', script_name], check=True)
    except subprocess.CalledProcessError as e:
        print(f"Error occurred while running {script_name}: {e}")

def main():
    print("Please press 'a' if you want to convert a video to another video format")
    print("Please press 'b' if you want to convert a video to an audio format")

    choice = input("Your choice: ").strip().lower()

    if choice == 'a':
        run_script('ffmpegfmtchg.py')
    elif choice == 'b':
        run_script('ffmpegfmtchgtomp3.py')
    else:
        print("Invalid choice. Please press 'a' or 'b'.")

if __name__ == "__main__":
    main()