import subprocess

def run_script(script_name):
    try:
        subprocess.run(['python', f'{script_name}.py'], check=True)
    except subprocess.CalledProcessError as e:
        print(f"Error occurred while running {script_name}.py: {e}")

def main():
    print("Please press 'a' if you want to convert video")
    print("Please press 'b' if you want to convert image")

    choice = input("Your choice: ").strip().lower()

    if choice == 'a':
        run_script('ffmpegstrt')
    elif choice == 'b':
        run_script('imgcvrtstrt')
    else:
        print("Invalid choice. Please press 'a' or 'b'.")

if __name__ == "__main__":
    main()